/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.analyse;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class SousCorpus {
    private Map<Integer, Boolean> listeTags;

    public SousCorpus(){
        listeTags = new HashMap<Integer, Boolean> ();
    }

    public void accepte(int tag){
        listeTags.put(new Integer(tag), new Boolean(true));
    }

    public void accepteTout(int debut, int fin){
        for(int i=debut; i<=fin; i++){
            accepte(i);
        }
    }

    public void refuseTout(int debut, int fin){
        for(int i=debut; i<=fin; i++){
            refuse(i);
        }
    }

    public void refuse(int tag){
        listeTags.put(new Integer(tag), new Boolean(false));
    }

    public int[] listeTagsAcceptes(){
        Vector<Integer> res = new Vector<Integer>();
        Vector<Integer> tags = new Vector<Integer>(listeTags.keySet());
        for(int i=0; i<tags.size(); i++){
            if(listeTags.get(tags.elementAt(i)).booleanValue()){
                res.addElement(tags.elementAt(i));
            }
        }
        int[] res2 = new int[res.size()];
        for(int i=0; i<res.size(); i++){
            res2[i] = res.elementAt(i).intValue();
        }
        return res2;
    }

    public int[] listeTagsRefuses(){
        Vector<Integer> res = new Vector<Integer>();
        Vector<Integer> tags = new Vector<Integer>(listeTags.keySet());
        for(int i=0; i<tags.size(); i++){
            if(!(listeTags.get(tags.elementAt(i)).booleanValue())){
                res.addElement(tags.elementAt(i));
            }
        }
        int[] res2 = new int[res.size()];
        for(int i=0; i<res.size(); i++){
            res2[i] = res.elementAt(i).intValue();
        }
        return res2;
    }
}
